#include "LPC15xx.h"

extern void SCT1_Init(void);

void SCT1_IRQHandler(void)
{
    LPC_SCT1->CTRL_L |=  (1 << 3);                     // clear the L counter
    LPC_SCT1->CTRL_L &= ~(1 << 1);                     // start the L counter

    LPC_SCT1->EVFLAG  = (1 << 1);                      // clear event 1 interrupt flag
}

int main (void)
{
    LPC_SYSCON->SYSAHBCLKCTRL1  |= EN1_SCT_IPU;        // enable SCT_IPU clock
    LPC_SYSCON->SYSAHBCLKCTRL0  |= EN0_SWM    |        // enable SWM clock
                                   EN0_P_MUX  |        // enable PMUX clock
                                   EN0_IOCON;          // enable IOCON clock

    LPC_SWM->PINASSIGN8         |= 0x0000FFFF;         // ASSIGN8(15:0) = FFFF
    LPC_SWM->PINASSIGN8         &= 0xFFFF0001;         // SCT1_OUT0 = P0.1 = blue LED
                                                       // SCT1_OUT1 = P0.0 = red LED
    LPC_SWM->PINASSIGN10        |= 0x0000FF00;         // ASSIGN10(15:8) = FF
    LPC_SWM->PINASSIGN10        &= 0xFFFF29FF;         // P1.9 (SW2) = SCT_ABORT0
    LPC_SCT_IPU->ABORT[1].ENABLE = 1;                  // enable SCT_ABORT0 from SWM
    LPC_PMUX->SCT1_P_MUX0        = 17;                 // SCT1_IN0 = SCTIPU_ABORT = P1.9 (SW2)

    SCT1_Init();                                       // Initialize SCT0

    while (1)                                          // loop forever
    {
    }
}
